/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills.core;

import com.google.common.base.Preconditions;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.skill.ISkill;
import dev.toma.gunsrpg.api.common.skill.ISkillHierarchy;
import dev.toma.gunsrpg.api.common.skill.ISkillProperties;
import dev.toma.gunsrpg.common.skills.core.DisplayData;
import dev.toma.gunsrpg.common.skills.core.DisplayType;
import dev.toma.gunsrpg.resource.skill.SkillPropertyLoader;
import dev.toma.gunsrpg.util.SkillUtil;
import java.util.function.Function;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SkillType<S extends ISkill>
extends ForgeRegistryEntry<SkillType<?>> {
    private final IFactory<S> instanceFactory;
    private final S dataInstance;
    private final Localization<S> localization;
    private final Function<SkillType<S>, DisplayData> displayDataFactory;
    private DisplayData displayData;
    private ClientState state;
    private ISkillHierarchy<S> hierarchy;
    private ISkillProperties properties;
    private boolean disabled;

    private SkillType(Builder<S> builder) {
        this.instanceFactory = ((Builder)builder).factory;
        this.dataInstance = this.instantiate();
        this.localization = new Localization(((Builder)builder).descriptionLines, this, ((Builder)builder).titleBuilder, ((Builder)builder).descriptionBuilder);
        this.displayDataFactory = ((Builder)builder).displayDataFactory;
        this.state = ClientState.NORMAL;
    }

    public S getDataInstance() {
        return this.dataInstance;
    }

    public S instantiate() {
        return this.instanceFactory.create(this);
    }

    public ISkillHierarchy<S> getHierarchy() {
        return this.hierarchy;
    }

    public ISkillProperties getProperties() {
        return this.properties;
    }

    public DisplayData getDisplayData() {
        return this.displayData;
    }

    public void setFresh() {
        this.state = ClientState.NEW;
    }

    public boolean isFresh() {
        return this.state == ClientState.NEW;
    }

    public void acknowledge() {
        this.state = ClientState.NORMAL;
    }

    public boolean isDisabled() {
        return this.disabled || GunsRPG.config.skills.disableAllSkills || this.hierarchy != null && this.hierarchy.getParent() != null && this.hierarchy.getParent().isDisabled();
    }

    public void onDataAssign(SkillPropertyLoader.ILoadResult<S> result) {
        this.hierarchy = result.hierarchy();
        this.properties = result.properties();
        this.disabled = result.disabled();
        this.displayData = this.displayDataFactory.apply(this);
    }

    public ITextComponent getTitle() {
        return this.localization.getTitle();
    }

    public ITextComponent[] getDescription() {
        return this.localization.getDescription();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SkillType type = (SkillType)((Object)obj);
        return type.getRegistryName().equals((Object)this.getRegistryName());
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }

    public String toString() {
        return "SkillType{" + this.getRegistryName().toString() + "}";
    }

    public static enum ClientState {
        NORMAL,
        NEW;

    }

    protected static class Localization<S extends ISkill> {
        private final int lineCount;
        private final SkillType<S> type;
        private final Function<SkillType<S>, ITextComponent> titleBuilder;
        private final IDescriptionBuilder<S> descriptionBuilder;
        private boolean loaded;
        private ITextComponent title;
        private ITextComponent[] description;

        public Localization(int lines, SkillType<S> type, Function<SkillType<S>, ITextComponent> titleBuilder, IDescriptionBuilder<S> descriptionBuilder) {
            this.lineCount = lines;
            this.type = type;
            this.titleBuilder = titleBuilder;
            this.descriptionBuilder = descriptionBuilder;
        }

        protected ITextComponent getTitle() {
            if (!this.loaded) {
                this.loadData();
            }
            return this.title;
        }

        protected ITextComponent[] getDescription() {
            if (!this.loaded) {
                this.loadData();
            }
            return this.description;
        }

        private void loadData() {
            this.title = this.titleBuilder.apply(this.type);
            this.description = this.descriptionBuilder.getDescription(this.lineCount, this.type);
            this.loaded = true;
        }
    }

    public static class Builder<S extends ISkill> {
        private final IFactory<S> factory;
        private Function<SkillType<S>, ITextComponent> titleBuilder = SkillUtil.Localizations::getDefaultTitle;
        private IDescriptionBuilder<S> descriptionBuilder = SkillUtil.Localizations::getDefaultDescription;
        private Function<SkillType<S>, DisplayData> displayDataFactory = SkillUtil::getDefaultDisplayData;
        private int descriptionLines = 1;

        private Builder(IFactory<S> factory) {
            this.factory = factory;
        }

        public static <S extends ISkill> Builder<S> create(IFactory<S> factory) {
            return new Builder<S>(factory);
        }

        public Builder<S> description(int lines) {
            this.descriptionLines = lines;
            return this;
        }

        public Builder<S> description(int lines, IDescriptionBuilder<S> builder) {
            this.descriptionBuilder = builder;
            return this.description(lines);
        }

        public Builder<S> description(IDescriptionBuilder<S> builder) {
            return this.description(1, builder);
        }

        public Builder<S> title(Function<SkillType<S>, ITextComponent> titleBuilder) {
            this.titleBuilder = titleBuilder;
            return this;
        }

        public Builder<S> render(Function<SkillType<S>, DisplayData> displayDataFactory) {
            this.displayDataFactory = displayDataFactory;
            return this;
        }

        public Builder<S> renderModIcon(String icon) {
            return this.render(type -> DisplayData.create(DisplayType.ICON, SkillUtil.moddedIcon(icon)));
        }

        public SkillType<S> build() {
            this.validate();
            return new SkillType(this);
        }

        private void validate() {
            Preconditions.checkNotNull(this.factory, (Object)"Instance factory cannot be null");
            Preconditions.checkState((this.descriptionLines >= 0 ? 1 : 0) != 0, (Object)"Skill type cannot have negative count of description lines");
        }
    }

    @FunctionalInterface
    public static interface IDescriptionBuilder<S extends ISkill> {
        public ITextComponent[] getDescription(int var1, SkillType<S> var2);
    }

    @FunctionalInterface
    public static interface IFactory<S extends ISkill> {
        public S create(SkillType<S> var1);
    }
}

